// 2003/03/18 limitsConfig.cs
// Copyright (C) Ortana<ortaclient@hotmail.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

using System;

namespace NTF.HXD.DOC
{
	/// <summary>
	/// limitsJeS̐ݒ܂B
	/// </summary>
	public class LimitsConfig : IConfig
	{


		#region ݒ荀
		string total_downloads = "64";
		/// <summary>
		/// T[o[̍ő_E[h
		/// </summary>
		[ValueType("UInt")]
		public string Total_downloads
		{
			get{return total_downloads;}
			set
			{
				try
				{
					uint.Parse( value );
				}
				catch
				{
					return;
				}

				total_downloads = value;
			}
		}

		string total_uploads = "64";
		/// <summary>
		/// T[o[̍őAbv[h
		/// </summary>
		[ValueType("UInt")]
		public string Total_uploads
		{
			get{return total_uploads;}
			set
			{
				try
				{
					uint.Parse( value );
				}
				catch
				{
					return;
				}

				total_uploads = value;
			}
		}

		string individual_downloads = "1";
		/// <summary>
		/// [UxɃ_E[hł鐔
		/// </summary>
		[ValueType("UInt")]
		public string Individual_downloads
		{
			get{return individual_downloads;}
			set
			{
				try
				{
					uint.Parse( value );
				}
				catch
				{
					return;
				}

				individual_downloads = value;
			}
		}

		string individual_uploads = "1";
		/// <summary>
		/// [U[xɃAbv[hł鐔
		/// </summary>
		[ValueType("UInt")]
		public string Individual_uploads
		{
			get{return individual_uploads;}
			set
			{
				try
				{
					uint.Parse( value );
				}
				catch
				{
					return;
				}

				individual_uploads = value;
			}
		}

		string out_Bps = "0";
		/// <summary>
		/// _E[hx
		/// </summary>
		/// <remarks>
		/// 0őxȂB
		/// </remarks>
		[ValueType("UInt")]
		public string Out_Bps
		{
			get{return out_Bps;}
			set
			{
				try
				{
					uint.Parse( value );
				}
				catch
				{
					return;
				}

				out_Bps = value;
			}
		}

		string  uploader_out_Bps = "0";
		/// <summary>
		/// Abv[hx
		/// </summary>
		/// <remarks>
		/// 0őxȂB
		/// </remarks>
		[ValueType("UInt")]
		public string  Uploader_out_Bps
		{
			get{return  uploader_out_Bps;}
			set
			{
				try
				{
					uint.Parse( value );
				}
				catch
				{
					return;
				}

				uploader_out_Bps = value;
			}
		}
		#endregion


		public LimitsConfig()
		{
		}


		public void Parse(Context context)
		{
			while(true)
			{
				string token = context.NextToken();
				if( token == null || token.Equals("}") )
				{
					break;
				}
				
				switch(token)
				{
					case"total_downloads":
						this.Total_downloads = context.NextToken();
						break;

					case"total_uploads":
						this.Total_uploads = context.NextToken();
						break;

					case"individual_downloads":
						this.Individual_downloads = context.NextToken();
						break;

					case"individual_uploads":
						this.individual_uploads = context.NextToken();
						break;

					case"out_Bps":
						this.Out_Bps = context.NextToken();
						break;

					case"uploader_out_Bps":
						this.Uploader_out_Bps = context.NextToken();
						break;

					default:
						context.NextToken();
						break;
				}
			}
		}

		public System.Text.StringBuilder Save(System.Text.StringBuilder b)
		{

			ConfigWriter writer = new ConfigWriter( b );
			writer.StartCategory( "limits" );
			writer.WriteComment("limit on how many downloads/uploads can run at the same time");
			writer.WriteProperty("total_downloads" , this.Total_downloads );
			writer.WriteProperty("total_uploads" , this.total_uploads );
			writer.WriteLine();
//			writer.WriteComment("limit on how many downloads/uploads can be run by each user at the same time");
//			writer.WriteProperty("individual_downloads" ,this.Individual_downloads );
//			writer.WriteProperty("individual_uploads" , this.individual_uploads );
			writer.WriteLine();
			writer.WriteComment("limit on how many bytes will be sent per second with each download");
			writer.WriteComment("0 means no limit");
			writer.WriteProperty("out_Bps" , this.Out_Bps );
			writer.WriteLine();
			writer.WriteComment("if not 0, those uploading will be limited by this instead of out_Bps");
			writer.WriteProperty("uploader_out_Bps" , this.Uploader_out_Bps);
			writer.EndCategory();

			return b;
		}


	}
}
